//Exp 5.3 Program Title:Image Enhancement using neighbourhood processing  high boost filter 
//environment: Scilab 5.5.2
//Toolbox: Image Processing Design 8.3.1-1
//Toolbox: SIVP 0.5.3.2
//Tested on OS: Windows 7 Professional, 64 bit
//Reference books names : 1)Digital Image Processing book author :
// Rafael C.Gonzalez and Richard E.Woods,
//2)Digital Image Processing book author :S.Sudhir,
//3)Digital Image Processing book author :Dhanajay Theckedath
clc //to clear command window.
clear all //to disable previously defined variables.
xdel(winsid());///clear all the previous figures plots
SIVP_PATH = getSIVPpath(); //to locate a directory in which SIVP toolbox is installed
im1=imread(SIVP_PATH + 'images/rose.bmp');//read  color image from diractory
im2=rgb2gray(im1);//grayscale image
im3=double(im2);
w=[-1 -1 -1; -1 8.9 -1; -1 -1 -1];//high boost filter mask
w1=[-1 -1 -1; -1 9.1 -1; -1 -1 -1];//high boost filter mask
w2=[-1 -1 -1; -1 9.3 -1; -1 -1 -1];//high boost filter mask
w3=[-1 -1 -1; -1 10 -1; -1 -1 -1];//high boost filter mask
[av1]=masking(im3,w);//convolution process
[av2]=masking(im3,w1);//convolution process
[av3]=masking(im3,w2);//convolution process
[av4]=masking(im3,w3);//convolution process
figure(1);ShowColorImage(im1,'Color image');title('Color image','color','red','fontsize',6);//IPD Toolbox
figure(2);ShowImage(im2,'Grayscale image');title('Grayscale image','color','red','fontsize',6);//IPD Toolbox
figure(3);ShowImage(av1,'High boost filtered Image');title('High boost filtered Image','color','red','fontsize',6);//IPD Toolbox
figure(4);ShowImage(av2,'High boost filtered Image for 9.1');title('High boost filtered Image for 9.1','color','red','fontsize',6);//IPD Toolbox
figure(5);ShowImage(av3,'High boost filtered Image for 9.3');title('High boost filtered Image for 9.3','color','red','fontsize',6);//IPD Toolbox
figure(6);ShowImage(av4,'High boost filtered Image for 10');title('High boost filtered Image for 10','color','red','fontsize',6);//IPD Toolbox
